/* This notice must be untouched at all times.

wz_dragdrop.js	v. 4.41
The latest version is available at
http://www.walterzorn.com
or http://www.devira.com
or http://www.walterzorn.de

Copyright (c) 2002-2003 Walter Zorn. All rights reserved.
Created 26. 8. 2002 by Walter Zorn <walter@kreuzotter.de>
Last modified: 27. 4. 2003

This DHTML & Drag&Drop Library adds Drag&Drop functionality
to the following types of html-elements,
provided their names/IDs are passed to SET_DHTML():
- images, even if not positioned via layers,
  nor via stylesheets or any other kind of "hard-coding"
- relatively and absolutely positioned layers (DIV elements).
Moreover, it has extended DHTML abilities,
such as moving, resizing and hiding elements, changing their z-indices,
(all this with layers as well as with images),
swapping images, changing background colors,
writing to layers
or detaching images from their container layers

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License
at http://www.gnu.org/copyleft/gpl.html for more details.
*/


// PATH TO THE TRANSPARENT 1*1 PX IMAGE (required by NS 4 as spacer)
var spacer = 'transparentpixel.gif';






//window.onerror = new Function('return true;');






// Optional commands on the html-page (g: may be used globally, i: may be used individually)
var CLONE            = 'C10nE';        // i  img      clone image
var COPY             = 'C0pY';         // i  img      create copies
var DETACH_CHILDREN  = 'd37aCH';       // i  lyr      detach images
var HORIZONTAL       = 'H0r1Z';        // i  img,lyr  only horizontally draggable
var MAXOFFBOTTOM     = 'm7xd0wN';      // i  img,lyr  downward offset limit
var MAXOFFLEFT       = 'm7x23Ft';      // i  img,lyr  leftward offset limit
var MAXOFFRIGHT      = 'm7x8IGT';      // i  img,lyr  rightward offset limit
var MAXOFFTOP        = 'm7xu9';        // i  img,lyr  upward offset limit
var NO_ALT           = 'no81T';        // gi img      disable alt and title attributes
var NOALT            = NO_ALT;
var NO_SCROLL        = 'nAU7O5cR';     // gi img,lyr  disable auto scroll functionality
var NOSCROLL         = NO_SCROLL;
var NO_DRAG          = 'N0d4Ag';       // i  img,lyr  disable draggability
var NODRAG           = NO_DRAG;
var KEYDOWN_RESIZE   = 'mSre5Z';       // gi img,lyr  resizable if <ctrl> or <shift> pressed
var RESET_Z          = 'r35E7z';       // gi img,lyr  reset z-index when dropped
var VERTICAL         = 'V3Rt1C';       // i  img,lyr  only vertically draggable



var dd_cursors = new Array(
	'c:move',
	'c:crosshair',
	'c:pointer',
	'c:wait',
	'c:help',
	'c:n-resize',
	'c:ne-resize',
	'c:e-resize',
	'c:se-resize',
	'c:s-resize',
	'c:sw-resize',
	'c:w-resize',
	'c:nw-resize'
);
for (dd_i = 0; dd_i < dd_cursors.length; dd_i++)
	eval('var CURSOR_' + (dd_cursors[dd_i].substring(2).toUpperCase().replace('-', '_')) + ' = "' + dd_cursors[dd_i] + '";');






function DDClass()
{
	this.n = navigator.userAgent.toLowerCase();
	this.db = (document.compatMode && document.compatMode.toLowerCase() != "backcompat")?
		document.documentElement
		: (document.body || null);
	this.op = (window.opera && document.getElementById);
	this.op6 = (this.op && !(this.db && this.db.innerHTML));
	if (this.op && !this.op6) document.onmousedown = new Function('e',
		'if (((e = e || window.event).target || e.srcElement).tagName == "IMAGE") return false;'
	);
	this.ie = this.n.indexOf("msie") != -1 && document.all && this.db && !this.op;
	this.iemac = this.ie && this.n.indexOf("mac")!=-1;
	this.ie4 = this.ie && !document.getElementById;
	this.n4 = (document.layers && typeof document.classes != "undefined");
	this.sfr = this.n.indexOf("safari") > -1;
	this.n6 = !this.op && !this.ie && typeof window.getComputedStyle != "undefined" && typeof document.createRange != "undefined";
	this.ce = document.captureEvents && document.releaseEvents;
	this.px = (this.n4 || this.op6)? '' : 'px';
	this.elements = new Array();
}
var dd = new DDClass();



dd.Int = function(d_x, d_y)
{
	return isNaN(d_y = parseInt(d_x))? 0 : d_y;
}



dd.getWndW = function()
{
	return dd.Int(
		(dd.db && !dd.op6 && dd.db.clientWidth)? dd.db.clientWidth
		: (window.innerWidth || 770)
	);
}



dd.getWndH = function()
{
	return dd.Int(
		(dd.db && !dd.op6 && dd.db.clientHeight)? dd.db.clientHeight
		: (window.innerHeight || 500)
	);
}



dd.getScrollX = function()
{
	return dd.Int(
		(dd.db && dd.db.scrollLeft)? dd.db.scrollLeft
		: (window.pageXOffset || 0)
	);
}



dd.getScrollY = function()
{
	return dd.Int(
		(dd.db && dd.db.scrollTop)? dd.db.scrollTop
		: (window.pageYOffset  || 0)
	);
}



dd.getPageX = function(d_o)
{
	if (dd.n4) return d_o.pageX || 0;
	var d_y = 0;
	while (d_o)
	{
		d_y += dd.Int(d_o.offsetLeft);
		d_o = d_o.offsetParent;
	}
	if (dd.iemac) d_y += dd.Int(dd.db.currentStyle.marginLeft) + dd.Int(dd.db.currentStyle.paddingLeft);
	return d_y;
}



dd.getPageY = function(d_o)
{
	if (dd.n4) return d_o.pageY || 0;
	var d_y = 0;
	while (d_o)
	{
		d_y += dd.Int(d_o.offsetTop);
		d_o = d_o.offsetParent;
	}
	if (dd.iemac) d_y += dd.Int(dd.db.currentStyle.marginTop) + dd.Int(dd.db.currentStyle.paddingTop);
	return d_y;
}



dd.getCssX = function(d_o)
{
	if (dd.n4) return d_o.div? d_o.div.x : 0;
	if (dd.ie4) return d_o.div? d_o.css.pixelLeft : 0;
	var d_y = 0;
	if (d_o.div)
	{
		d_o.css.left = 0 + dd.px;
		d_y = d_o.x - dd.getPageX(d_o.div);
		d_o.css.left = d_y + dd.px;
	}
	return d_y;
}



dd.getCssY = function(d_o)
{
	if (dd.n4) return d_o.div? d_o.div.y : 0;
	if (dd.ie4) return d_o.div? d_o.css.pixelTop : 0;
	var d_y = 0;
	if (d_o.div)
	{
		d_o.css.top = 0 + dd.px;
		d_y = d_o.y - dd.getPageY(d_o.div);
		d_o.css.top = d_y + dd.px;
	}
	return d_y;
}



dd.getImgW = function(d_o)
{
	if (dd.n6 && d_o) return dd.Int(window.getComputedStyle(d_o, null).getPropertyValue("width"));
	if (d_o) return dd.Int(d_o.width);
	return 0;
}



dd.getImgH = function(d_o)
{
	if (dd.n6 && d_o) return dd.Int(window.getComputedStyle(d_o, null).getPropertyValue("height"));
	if (d_o) return dd.Int(d_o.height);
	return 0;
}



dd.getDivW = function(d_o)
{
	return dd.Int(
		dd.n4? (d_o.div? d_o.div.clip.width : 0)
		: d_o.div? (d_o.div.offsetWidth || d_o.css.pixelWidth || d_o.css.width || 0)
		: 0
	);
}



dd.getDivH = function(d_o)
{
	return dd.Int(
		dd.n4? (d_o.div? d_o.div.clip.height : 0)
		: d_o.div? (d_o.div.offsetHeight || d_o.css.pixelHeight || d_o.css.height || 0)
		: 0
	);
}



dd.getWH = function(d_o)
{
	d_o.w = dd.getDivW(d_o);
	d_o.h = dd.getDivH(d_o);

	if (d_o.css)
	{
		d_o.css.width = d_o.w + dd.px;
		d_o.css.height = d_o.h + dd.px;
		d_o.dw = dd.getDivW(d_o)-d_o.w;
		d_o.dh = dd.getDivH(d_o)-d_o.h;
		d_o.css.width = (d_o.w-d_o.dw) + dd.px;
		d_o.css.height = (d_o.h-d_o.dh) + dd.px;
	}
	else d_o.dw = d_o.dh = 0;
}



dd.getDiv = function(d_x)
{
	if (dd.n4) return document.layers[d_x] || null;
	if (dd.ie) return document.all[d_x] || null;
	return document.getElementById(d_x) || null;
}



dd.getImg = function(d_o, d_nm, d_xy, d_w)
{
	d_w = d_w || window;
	var d_img;
	if ((d_img = d_w.document.images[d_nm]) && d_img.name == d_nm)
	{
		if (d_xy)
		{
			if (dd.n4)
			{
				d_o.defx = d_img.x + dd.getPageX(d_w);
				d_o.defy = d_img.y + dd.getPageY(d_w);
			}
			else
			{
				d_o.defx = dd.getPageX(d_img);
				d_o.defy = dd.getPageY(d_img);
			}
		}
		return d_img;
	}
	if (dd.n4) for (var d_i = 0; d_i < d_w.document.layers.length; d_i++)
	{
		var d_y = dd.getImg(d_o, d_nm, d_xy, d_w.document.layers[d_i]);
		if (d_y) return d_y;
	}
	return null;
}



dd.getChildren = function(d_o)
{
	d_o.children = new Array();
	for (var d_i = dd.elements.length-1; d_i >= 0; d_i--)
	{
		var d_p = dd.elements[d_i],
		d_q = d_p.oimg = d_p.is_image? dd.getImg(d_p, d_p.imgname) : null;
		if (d_q)
		{
			if (dd.n4)
			{
				if (d_o.div.document)
				{
					for (var d_j = d_o.div.document.images.length-1; d_j >= 0; d_j--)
					{
						if (d_o.div.document.images[d_j] == d_q)
						{
							d_o.addChild(d_p, d_o.detach, true);
							break;
						}
					}
				}
			}
			else while (d_q.offsetParent || d_q.parentNode)
			{
				if ((d_q.offsetParent || d_q.parentNode) == d_o.div)
				{
					d_o.addChild(d_p, d_o.detach, true);
					break;
				}
				d_q = d_q.offsetParent || d_q.parentNode || null;
			}
		}
	}
}



dd.getCmd = function(d_o, d_cmd)
{
	var d_i = d_o.id.indexOf(d_cmd),
	d_y = (d_i >= 0);
	if (d_y) d_o.id = d_o.id.substring(0, d_i) + d_o.id.substring(d_i+d_cmd.length);
	return d_y;
}



dd.getCmdVal = function(d_o, d_cmd, infin)
{
	var d_i = d_o.id.indexOf(d_cmd),
	d_y = (d_o.id.indexOf(d_cmd) >= 0)? dd.Int(d_o.id.substring(d_o.id.indexOf(d_cmd)+d_cmd.length)) : infin? -1 : 0;
	if (!infin && d_y || infin && d_y >= 0) d_o.id = d_o.id.substring(0, d_i) + d_o.id.substring(d_i+d_cmd.length+d_y.toString().length);
	return d_y;
}



dd.addElt = function(d_o, d_p)
{
	dd.elements[dd.elements.length] = dd.elements[d_o.name] = d_o;
	if (d_p) d_p.copies[d_p.copies.length] = d_o;
}



dd.initImg = function(d_o)
{
	d_o.nimg = (dd.n4 && d_o.div)? d_o.div.document.images[0] : (document.images[d_o.id+'img'] || null);
	if (!d_o.noalt && !dd.noalt && d_o.nimg && d_o.oimg)
	{
		d_o.nimg.alt = d_o.oimg.alt || '';
		if (d_o.oimg.title) d_o.nimg.title = d_o.oimg.title;
	}
}



dd.addProps = function(d_o)
{
	var d_i;
	if (!d_o.is_image)
	{
		if (dd.n6 && d_o.div)
		{
			d_o.defz = dd.Int((d_i = window.getComputedStyle(d_o.div, null)).getPropertyValue('z-index'));
			var d_c = d_i.getPropertyValue('background-color');
			if (d_c.indexOf('rgb') >= 0)
			{
				d_c = d_c.substring(0x04).split(',');
				d_o.bgColor = '#';
				for (var d_i = 0; d_i < d_c.length; d_i++) d_o.bgColor += ''+parseInt(d_c[d_i]).toString(0x10);
			}
			else d_o.bgColor = d_c;
		}
		else if (d_o.div && d_o.div.currentStyle)
		{
			d_o.defz = dd.Int(d_o.div.currentStyle.zIndex);
			d_o.bgColor = d_o.div.currentStyle.backgroundColor;
		}
		else if (d_o.div)
		{
			d_o.defz = dd.Int((d_o.css || d_o.div).zIndex);
			d_o.bgColor = dd.n4? d_o.div.bgColor : (d_o.css.backgroundColor || d_o.css.background);
		}
		else
		{
			d_o.defz = 0;
			d_o.bgColor = '';
		}
	}
	else
	{
		d_o.bgColor = '';
		d_o.div = dd.getDiv(d_o.id);
		if (d_o.div && typeof d_o.div.style != "undefined") d_o.css = d_o.div.style;
		dd.initImg(d_o);
	}
	d_o.setZ(d_o.defz);
	d_o.keydown_resize = d_o.keydown_resize || dd.keydown_resize;
	d_o.cursor = d_o.nodrag? 'auto' : (dd.cursor || 'auto');
	if (d_o.css) d_o.css.cursor = d_o.cursor;
	d_o.visible = true;
}



dd.init = function()
{
	if (dd.op6) WINSZ(0x02);
	else if (dd.n6 || dd.ie || dd.op && !dd.op6 || dd.sfr) dd.recalc(true);
	var d_drag = (document.onmousemove == DRAG),
	d_resize = (document.onmousemove == RESIZE);
	if (dd.loadFunc) dd.loadFunc();
	if (d_drag && document.onmousemove != DRAG) dd.setEvtHdl('move', DRAG);
	else if (d_resize && document.onmousemove != RESIZE) dd.setEvtHdl('move', RESIZE);
	if ((d_drag || d_resize) && document.onmouseup != DROP) dd.setEvtHdl('up', DROP);
	dd.setEvtHdl('down', PICK);
}



dd.setEvtHdl = function(d_typ, d_func)
{
	if (d_typ == 'down')
	{
		if (document.onmousedown != d_func) dd.downFunc = document.onmousedown || null;
		document.onmousedown = d_func;
	}
	else if (d_typ == 'move')
	{
		if (document.onmousemove != d_func) dd.moveFunc = document.onmousemove || null;
		document.onmousemove = d_func;
	}
	else
	{
		if (document.onmouseup != d_func) dd.upFunc = document.onmouseup || null;
		document.onmouseup = d_func;
	}
	if (dd.ce)
	{
		var d_e = (d_typ == 'down')? Event.MOUSEDOWN : (d_typ == 'move')? Event.MOUSEMOVE : Event.MOUSEUP;
		if (d_func) document.captureEvents(d_e);
		else document.releaseEvents(d_e);
	}
}



dd.evt = function(d_e)
{
	this.but = (d_e = d_e || window.event).which || d_e.button || 0;
	this.button = (d_e.type == 'mousedown')? this.but
		: (dd.e && dd.e.button)? dd.e.button
		: 0;
	this.type = d_e.type;
	this.src = d_e.target || d_e.srcElement || null;
	this.src.tag = (this.src.tagName || this.src).toString().toLowerCase();
	this.x = dd.Int(d_e.pageX || d_e.clientX || 0);
	this.y = dd.Int(d_e.pageY || d_e.clientY || 0);
	if (dd.ie || dd.sfr)
	{
		this.x += dd.getScrollX();
		this.y += dd.getScrollY();
	}
	this.shiftKey = d_e.modifiers? (d_e.modifiers & Event.SHIFT_MASK || d_e.modifiers & Event.CONTROL_MASK)
		: (d_e.shiftKey || d_e.ctrlKey || false);
}



// re-integrate items after page reflow
dd.recalc = function(d_x)
{
	var d_o;
	for (var d_i = dd.elements.length-1; d_i >= 0; d_i--)
	{
		if ((d_o = dd.elements[d_i]).is_image)
		{
			if (dd.n6 && d_x) d_o.resizeTo(d_o.defw = dd.getImgW(d_o.oimg), d_o.defh = dd.getImgH(d_o.oimg));
			var d_defx = d_o.defx, d_defy = d_o.defy;
			if (!(d_o.parent && d_o.parent != d_o.defparent) && (d_x || !d_o.detached || d_o.horizontal || d_o.vertical) && dd.getImg(d_o, d_o.imgname, true))
				d_o.moveBy(d_o.defx-d_defx, d_o.defy-d_defy);
		}
		else
		{
			dd.getWH(d_o);
			if (d_o.div.pos_rel)
			{
				var d_dx = dd.getPageX(d_o.div) - d_o.x;
				var d_dy = dd.getPageY(d_o.div) - d_o.y;
				d_o.defx += d_dx;
				d_o.x += d_dx;
				d_o.defy += d_dy;
				d_o.y += d_dy;
				if (d_o.children)
				{
					var d_p;
					for (var d_j = d_o.children.length-1; d_j >= 0; d_j--)
					{
						if (!(d_p = d_o.children[d_j]).detached && (d_o != d_p.defparent || !dd.getImg(d_p, d_p.imgname, true)))
						{
							d_p.defx += d_dx;
							d_p.defy += d_dy;
							d_p.moveBy(d_dx, d_dy);
						}
					}
				}
			}
		}
	}
}



dd.n4RectVis = function(vis)
{
	for (var d_i = 0x03; d_i >= 0; d_i--)
	{
		dd.rectI[d_i].visibility = dd.rectA[d_i].visibility = vis? 'show' : 'hide';
		if (vis) dd.rectI[d_i].zIndex = dd.rectA[d_i].zIndex = dd.obj.z + 1;
	}
}



dd.n4RectPos = function(d_o, d_x, d_y, d_w, d_h)
{
	d_o.x = d_x;
	d_o.y = d_y;
	d_o.clip.width = d_w;
	d_o.clip.height = d_h;
}



// NN4: draw img resize rectangle
dd.n4Rect = function(d_dx, d_dy)
{
	if (!dd.rectI)
	{
		dd.rectI = new Array();
		dd.rectA = new Array();
	}
	if (!dd.rectI[0])
	{
		for (var d_i = 0x03; d_i >= 0; d_i--)
		{
			dd.rectI[d_i] = new Layer(1);
			dd.rectA[d_i] = new Layer(1);
			dd.rectI[d_i].bgColor = '#000000';
			dd.rectA[d_i].bgColor = '#ffffff';
		}
	}
	if (!dd.rectI[0].visibility || dd.rectI[0].visibility == 'hide') dd.n4RectVis(true);
	dd.obj.w = Math.max(dd.obj.w+d_dx, 1);
	dd.obj.h = Math.max(dd.obj.h+d_dy, 1);
	for (var d_i = 0x03; d_i >= 0; d_i--)
	{
		dd.n4RectPos(dd.rectI[d_i], dd.obj.x + (!(d_i-1)? (dd.obj.w-1) : 0), dd.obj.y + (!(d_i-0x02)? (dd.obj.h-1) : 0), (d_i&1)? 1 : dd.obj.w, (d_i&1)? dd.obj.h : 1);
		dd.n4RectPos(dd.rectA[d_i], !(d_i-1)? dd.rectI[1].x+1 : (dd.obj.x-1), !(d_i-0x02)? dd.rectI[2].y+1 : (dd.obj.y-1), (d_i&1)? 1 : (dd.obj.w+0x02), (d_i&1)? dd.obj.h+0x02 : 1);
	}
}



dd.resizeBy = function(d_dx, d_dy)
{
	if (dd.n4 && dd.obj.is_image) dd.n4Rect(d_dx, d_dy);
	else dd.obj.resizeBy(d_dx, d_dy);
}



dd.maxOffX = function(d_x)
{
	return (
		(dd.obj.maxoffl >= 0 && dd.obj.x+d_x < dd.obj.defx-dd.obj.maxoffl)? dd.obj.defx-dd.obj.maxoffl-dd.obj.x
		: (dd.obj.maxoffr >= 0 && dd.obj.x+d_x > dd.obj.defx+dd.obj.maxoffr)? dd.obj.defx+dd.obj.maxoffr-dd.obj.x
		: d_x
	);
}



dd.maxOffY = function(d_x)
{
	return (
		(dd.obj.maxofft >= 0 && dd.obj.y+d_x < dd.obj.defy-dd.obj.maxofft)? dd.obj.defy-dd.obj.maxofft-dd.obj.y
		: (dd.obj.maxoffb >= 0 && dd.obj.y+d_x > dd.obj.defy+dd.obj.maxoffb)? dd.obj.defy+dd.obj.maxoffb-dd.obj.y
		: d_x
	);
}



dd.reFalse = function()
{
	event.returnValue = false;
}





function DDObj(d_o, d_i)
{
	this.id = d_o;
	this.clone = dd.getCmd(this, CLONE);
	this.detach = dd.getCmd(this, DETACH_CHILDREN);
	this.horizontal = dd.getCmd(this, HORIZONTAL);
	this.noalt = dd.getCmd(this, NOALT);
	this.nodrag = dd.getCmd(this, NODRAG);
	this.noscroll = dd.getCmd(this, NO_SCROLL);
	this.keydown_resize = dd.getCmd(this, KEYDOWN_RESIZE);
	this.re_z = dd.getCmd(this, RESET_Z);
	this.vertical = dd.getCmd(this, VERTICAL);
	this.maxoffb = dd.getCmdVal(this, MAXOFFBOTTOM, true);
	this.maxoffl = dd.getCmdVal(this, MAXOFFLEFT, true);
	this.cpy_n = dd.getCmdVal(this, COPY);
	this.maxoffr = dd.getCmdVal(this, MAXOFFRIGHT, true);
	this.maxofft = dd.getCmdVal(this, MAXOFFTOP, true);

	this.name = this.id + (d_i || '');
	this.oimg = dd.getImg(this, this.id, true);
	this.is_image = (this.oimg != null);


	if (this.oimg)
	{
		this.imgname = this.id;
		this.id += 'div' + (d_i || '');
		this.w = dd.getImgW(this.oimg);
		this.h = dd.getImgH(this.oimg);
		this.dw = this.dh = 0;
		(this.cach = new Image()).src = this.defsrc = this.src = this.oimg.src;
		this.htm = '<div id="' + this.id +
			'" style="position:absolute;'+
			'left:' + (this.cssx = this.x = this.defx) + 'px;'+
			'top:' + (this.cssy = this.y = this.defy) + 'px;'+
			'width:' + this.w + 'px;'+
			'height:' + this.h + 'px;">'+
			'<img name="' + (this.id+'img') + '"'+
			' src="' + this.defsrc + '" '+
			'width="' + this.w + '" height="' + this.h + '"><\/div>';
	}
	else if (!!(this.div = dd.getDiv(this.id)))
	{
		if (typeof this.div.style != "undefined")	this.css = this.div.style;
		dd.getWH(this);
		this.div.pos_rel = ((this.div.parentNode? this.div.parentNode.tagName : this.div.parentElement? this.div.parentElement.tagName : '').toString().toLowerCase().indexOf('body') == -1)
		this.defx = this.x = dd.getPageX(this.div);
		this.defy = this.y = dd.getPageY(this.div);
		this.cssx = dd.getCssX(this);
		this.cssy = dd.getCssY(this);
	}


	this.defw = this.w;
	this.defh = this.h;
}



DDObj.prototype.moveBy = function(d_x, d_y, d_o)
{
	this.x += (d_x = dd.Int(d_x));
	this.y += (d_y = dd.Int(d_y));
	if (this.div)
	{
		(d_o = this.css || this.div).left = (this.cssx += d_x) + dd.px;
		d_o.top = (this.cssy += d_y) + dd.px;
	}
	if (this.children)
	{
		for (var d_i = this.children.length-1; d_i >= 0; d_i--)
		{
			if (!(d_o = this.children[d_i]).detached)
				d_o.moveBy(d_x, d_y);
			d_o.defx += d_x;
			d_o.defy += d_y;
		}
	}
}



DDObj.prototype.moveTo = function(d_x, d_y)
{
	this.moveBy(dd.Int(d_x)-this.x, dd.Int(d_y)-this.y);
}



DDObj.prototype.setZ = function(d_x)
{
	if (this.div) (this.css || this.div).zIndex = this.z = d_x;
	dd.z = Math.max(dd.z, d_x);
}



DDObj.prototype.hide = function(d_o)
{
	if (this.div) (this.css || this.div).visibility = "hidden";
	this.visible = false;
	if (this.children)
		for (var d_i = this.children.length-1; d_i >= 0; d_i--)
			if (!(d_o = this.children[d_i]).detached)
				d_o.hide();
}



DDObj.prototype.show = function()
{
	if (this.div) (this.css ||  this.div).visibility = "visible";
	this.visible = true;
	if (this.children)
		for (var d_i = this.children.length-1; d_i >= 0; d_i--)
			if (!(d_o = this.children[d_i]).detached)
				d_o.show();
}



DDObj.prototype.resizeTo = function(d_w, d_h, d_o)
{
	this.w = ((d_w = dd.Int(d_w)) > 0)? d_w : (d_w = 1);
	this.h = ((d_h = dd.Int(d_h)) > 0)? d_h : (d_h = 1);
	d_w -= this.dw;
	d_h -= this.dh;
	if (!this.div) return;
	if (dd.n4)
	{
		this.div.resizeTo(d_w, d_h);
		if (this.is_image)
		{
			(d_o = this.div.document).open();
			d_o.write('<img src="' + this.cach.src + '" width="' + d_w + '" height="' + d_h + '">');
			d_o.close();
			(this.nimg = d_o.images[0]).src = this.cach.src;
		}
	}
	else if (typeof this.css.pixelWidth != "undefined")
	{
		this.css.pixelWidth = d_w;
		this.css.pixelHeight = d_h;
		if (this.is_image)
		{
			(d_o = this.nimg.style).pixelWidth = d_w;
			d_o.pixelHeight = d_h;
		}
	}
	else
	{
		this.css.width = d_w + dd.px;
		this.css.height = d_h + dd.px;
		if (this.is_image)
		{
			(d_o = this.nimg).width = d_w;
			d_o.height = d_h;
			if (!d_o.complete) d_o.src = this.cach.src;
		}
	}
	if (this.css) this.css.overflow = this.css.overflow || "hidden";
}



DDObj.prototype.resizeBy = function(d_dw, d_dh)
{
	this.resizeTo(this.w+dd.Int(d_dw), this.h+dd.Int(d_dh));
}



DDObj.prototype.swapImage = function(d_x, d_cp)
{
	if (!this.is_image) return;
	if (this.cach.src != d_x) (this.cach = new Image()).src = d_x;
	if (this.nimg) this.nimg.src = this.src = this.cach.src;
	if (d_cp && this.copies)
		for (var d_i = this.copies.length-1; d_i >= 0; d_i--)
			this.copies[d_i].swapImage(d_x);
}



DDObj.prototype.setBgColor = function(d_x, d_o)
{
	if (dd.n4) this.div.bgColor = d_x;
	else if (this.css) this.css.background = d_x;
	this.bgColor = d_x;
}



DDObj.prototype.write = function(d_x)
{
	if (dd.n4)
	{
		var d_o = this.div.document;
		d_o.open();
		d_o.write(d_x);
		d_o.close();
		dd.getWH(this);
	}
	else if (!dd.op6)
	{
		this.css.height = 'auto';
		this.div.innerHTML = d_x;
		if (!dd.ie4) dd.recalc();
		if (dd.ie4 || dd.n6) setTimeout('dd.recalc();', 0); // n6.0: double recalc required
	}
}



DDObj.prototype.copy = function(d_n)
{
	if (!this.oimg) return;
	this.copies = this.copies || new Array();
	d_n = d_n ||  1;

	for (var d_i = 0; d_i < d_n; d_i++)
	{
		var d_l = this.copies.length,
		d_o = new DDObj(
			this.name +
			(this.clone? CLONE : '') +
			(this.noalt? NOALT : '') +
			(this.noscroll? NOSCROLL : '') +
			(this.keydown_resize? KEYDOWN_RESIZE : '') +
			(this.re_z? RESET_Z : ''),
			d_l+1
		);

		if (dd.n4)
		{
			var d_p = new Layer(1);
			d_o.id = d_p.name;
			d_p.clip.width = d_o.w;
			d_p.clip.height = d_o.h;
			d_p.visibility = 'show';
			d_p = d_p.document;
			d_p.open();
			d_p.write(d_o.htm.substring(d_o.htm.indexOf('<img'), d_o.htm.indexOf('<\/div>')));
			d_p.close();
		}
		else if (dd.db.insertAdjacentHTML) dd.db.insertAdjacentHTML("AfterBegin", d_o.htm);
		else if (dd.n6)
		{
			var d_x = document.createRange();
			d_x.setStartBefore(dd.db);
			dd.db.appendChild(d_x.createContextualFragment(d_o.htm));
		}
		else if (dd.db && dd.db.innerHTML) dd.db.innerHTML += d_o.htm;

		d_o.defz = 0x03+d_l;
		dd.addProps(d_o);
		d_o.original = this;
		dd.addElt(d_o, this);
		if (this.parent)
		{
			this.parent.addChild(d_o, this.detached);
			d_o.defparent = this.defparent;
		}
		d_o.moveTo(d_o.defx = this.defx, d_o.defy = this.defy);
		if (dd.n4) d_o.defsrc = d_o.src = this.defsrc;
		d_o.swapImage(this.src);
	}
}



DDObj.prototype.addChild = function(d_kd, detach, defp)
{
	if (typeof d_kd != "object") d_kd = dd.elements[d_kd];
	if (d_kd.parent && d_kd.parent == this) return;

	this.children[this.children.length] = this.children[d_kd.name] = d_kd;
	d_kd.detached = detach || false;
	if (defp) d_kd.defparent = this;
	else if (this == d_kd.defparent) dd.getImg(this, d_kd.imgname, true);
	if (!d_kd.defparent || this != d_kd.defparent)
	{
		d_kd.defx = d_kd.x;
		d_kd.defy = d_kd.y;
	}
	if (!detach)
	{
		if (defp) d_kd.setZ(d_kd.defz = this.z-0x02+d_kd.z);
		else d_kd.setZ(d_kd.defz = d_kd.z+this.z-(d_kd.parent? d_kd.parent.z : 0));
	}
	if (d_kd.parent) d_kd.parent.removeChild(d_kd, true);
	d_kd.parent = this;
}



DDObj.prototype.removeChild = function(d_kd, d_newp)
{
	if (typeof d_kd != "object") d_kd = this.children[d_kd];
	var d_oc = this.children,
	d_nc = new Array();
	for (var d_i = 0; d_i < d_oc.length; d_i++)
		if (d_oc[d_i] != d_kd) d_nc[d_nc.length] = d_oc[d_i];
	this.children = d_nc;
	d_kd.parent = null;
	if (!d_newp)
	{
		d_kd.detached = d_kd.defp = false;
		dd.getImg(d_kd, d_kd.imgname, true);
	}
}



DDObj.prototype.attachChild = function(d_kd)
{
	if (typeof d_kd != "object") d_kd = this.children[d_kd];
	d_kd.detached = false;
	d_kd.setZ(d_kd.defz + this.z-this.defz);
}



DDObj.prototype.detachChild = function(d_kd)
{
	if (typeof d_kd != "object") d_kd = this.children[d_kd];
	d_kd.detached = true;
}



DDObj.prototype.maximizeZ = function()
{
	var d_o, d_z = dd.z+1;
	if (this.children)
		for (var d_i = this.children.length-1; d_i >= 0; d_i--)
			if (!(d_o = this.children[d_i]).detached) d_o.setZ(d_z+d_o.z-this.z);
	this.setZ(d_z);
}



DDObj.prototype.resetZ = function(d_o)
{
	if (this.re_z || dd.re_z)
	{
		this.setZ(this.defz);
		if (this.children)
			for (var d_i = this.children.length-1; d_i >= 0; d_i--)
				if (!(d_o = this.children[d_i]).detached)
					d_o.setZ(d_o.defz);
	}
}



DDObj.prototype.setCursor = function(d_x)
{
	if (this.css) this.css.cursor = d_x;
}






function WINSZ(d_x)
{
	if (d_x == 1 || d_x == 0x02)
	{
		if (dd.n4 || dd.op6 && d_x == 0x02)
		{
			dd.iW = innerWidth;
			dd.iH = innerHeight;
			if (dd.op6) setTimeout("WINSZ()", 0x1ff);
		}
		window.onresize = WINSZ;
	}
	else if ((dd.n4 || dd.op6) && (innerWidth != dd.iW || innerHeight != dd.iH))
		location.reload();
	else if (dd.op6) setTimeout("WINSZ()", 0x1ff);
	else setTimeout('dd.recalc()', 0x0a);
}
WINSZ(1);






// Page auto-scrolling functionality. Idea for this feature courtesy Cedric Savarese.
function DDScroll()
{
	if (!dd.obj || dd.obj.noscroll || dd.noscroll || dd.op || dd.ie4)
	{
		dd.scrx = dd.scry = 0;
		return;
	}
	var d_bnd = 0x19,
	d_sft = 0x02,
	d_ww = dd.getWndW(),
	d_wh = dd.getWndH(),
	d_wx = dd.getScrollX(),
	d_wy = dd.getScrollY();


	if (!dd.mousemoved)
	{
		if (dd.scrx || dd.scry)
		{
			if (!d_wx && dd.scrx < 0 || dd.obj.vertical) dd.scrx = 0;
			if (!d_wy && dd.scry < 0 || dd.obj.horizontal) dd.scry = 0;
			dd.scrx = dd.maxOffX(dd.scrx);
			dd.scry = dd.maxOffY(dd.scry);
			if (dd.obj.is_dragged) dd.obj.moveBy(dd.scrx, dd.scry);
			else dd.resizeBy(dd.scrx, dd.scry);
			dd.prex += dd.scrx;
			dd.prey += dd.scry;
		}
	}
	else
	{
		dd.scrx = dd.obj.vertical? 0
			: (dd.e.x > d_ww + d_wx - d_bnd)? Math.pow((dd.e.x - d_ww - d_wx + d_bnd) >>d_sft, 0x02)
			: (dd.e.x < d_wx + d_bnd)? -Math.pow((d_wx + d_bnd - dd.e.x) >>d_sft, 0x02)
			: 0,
		dd.scry = dd.obj.horizontal? 0
			: (dd.e.y > d_wh + d_wy - d_bnd)? Math.pow((dd.e.y - dd.getWndH() - d_wy + d_bnd) >>d_sft, 0x02)
			: (dd.e.y < d_wy + d_bnd)? -Math.pow((d_wy + d_bnd - dd.e.y) >>d_sft, 0x02)
			: 0;
	}
	dd.mousemoved = false;


	if (dd.scrx || dd.scry)  window.scrollTo(d_wx+dd.scrx, d_wy+dd.scry);
	window.setTimeout('DDScroll()', 0x33);
}






function PICK(d_ev)
{
	dd.e = new dd.evt(d_ev);
	var d_o, d_cmp = -1;
	// return if target is scrollbar
	if (dd.e.x >= dd.getWndW()+dd.getScrollX() || dd.e.y >= dd.getWndH()+dd.getScrollY()) return true;
	for (var d_i = 0; d_i < dd.elements.length; d_i++)
	{
		d_o = dd.elements[d_i];
		if (dd.n4 && dd.e.but > 1 && dd.e.src == d_o.oimg && !d_o.clone) return false;
		if (d_o.visible && dd.e.but <= 1 && (!d_o.nodrag || dd.e.shiftKey && d_o.keydown_resize) && dd.e.x >= d_o.x && dd.e.x <= d_o.x+d_o.w && dd.e.y >= d_o.y && dd.e.y <= d_o.y+d_o.h)
		{
			if (d_o.z > d_cmp && dd.e.src.tag.indexOf('input') < 0 && dd.e.src.tag.indexOf('textarea') < 0)
			{
				d_cmp = d_o.z;
				dd.obj = d_o;
			}
			(d_ev || event).cancelBubble = true;
		}
	}
	if (dd.obj)
	{
		if (dd.op && !dd.op6)
		{
			(d_o = document.getElementById('OpBlUr')).style.pixelLeft = dd.e.x;
			d_o.style.pixelTop = dd.e.y;
			(d_o = d_o.children[0].children[0]).focus();
			d_o.blur();
		}
		else if (dd.db && typeof dd.db.onselectstart != "undefined" && !dd.ie4)
		{
			if (document.selection && document.selection.empty) document.selection.empty();
			dd.db.onselectstart = dd.reFalse;
		}

		if (dd.e.shiftKey && dd.obj.keydown_resize)
		{
			dd.obj.setCursor('se-resize');
			dd.obj.is_resized = true;
			if (dd.db && typeof dd.db.onselectstart != "undefined" || dd.ie4)
			{
				if (dd.ie4)
				{
					window.dd_x = dd.getScrollX();
					window.dd_y = dd.getScrollY();
				}
				setTimeout(
					'if (dd.obj && document.selection && document.selection.empty)'+
					'{'+
						'document.selection.empty();'+
						'if (dd.ie4) window.scrollTo(window.dd_x, window.dd_y);'+
					'}'
				,0);
			}
			dd.setEvtHdl('move', RESIZE);
		}
		else if (!dd.obj.nodrag)
		{
			dd.obj.is_dragged = true;
			dd.setEvtHdl('move', DRAG);
		}

		dd.setEvtHdl('up', DROP);
		dd.obj.maximizeZ();
		dd.prex = dd.e.x;
		dd.prey = dd.e.y;
		if (window.my_PickFunc) my_PickFunc();
		DDScroll();

		return !(
			dd.obj.is_resized
			||
			dd.n4 && dd.obj.is_image
			||
			dd.n6 || dd.sfr
		);
	}
	if (dd.downFunc) return dd.downFunc(d_ev);
	return true;
}



function DRAG(d_ev)
{
	if (!dd.obj || !dd.obj.visible) return true;
	if (dd.ie4 || dd.sfr || dd.n6 || dd.obj.children && dd.obj.children.length > 0x0f)
	{
		if (dd.wait) return false;
		dd.wait = true;
		setTimeout('dd.wait = false;', 0x05);
	}
	dd.e = new dd.evt(d_ev);
	if (dd.ie && !dd.e.but)
	{
		DROP();
		return true;
	}

	dd.mousemoved = true;
	var d_dx = dd.e.x-dd.prex,
	d_dy = dd.e.y-dd.prey;
	d_dx = dd.maxOffX(d_dx);
	if (dd.obj.vertical) d_dx = 0;
	d_dy = dd.maxOffY(d_dy);
	if (dd.obj.horizontal) d_dy = 0;
	dd.obj.moveBy(d_dx, d_dy);

	if (window.my_DragFunc) my_DragFunc();
	dd.prex += d_dx;
	dd.prey += d_dy;
	return false;
}



function RESIZE(d_ev)
{
	if (!dd.obj || !dd.obj.visible) return true;
	if (dd.wait) return false;
	dd.wait = true;
	setTimeout('dd.wait = false;', 0x05);
	dd.e = new dd.evt(d_ev);
	if (dd.ie && !dd.e.but)
	{
		DROP();
		return true;
	}

	dd.mousemoved = true;
	dd.resizeBy(dd.e.x-dd.prex, dd.e.y-dd.prey);

	if (window.my_ResizeFunc) my_ResizeFunc();
	dd.prex = dd.e.x;
	dd.prey = dd.e.y;
	return false;
}



function DROP(d_ev)
{
	if (dd.obj)
	{
		if (dd.obj.is_dragged)
		{
			if (!dd.obj.is_image) dd.getWH(dd.obj);
		}
		else if (dd.n4)
		{
			if (dd.obj.is_image)
			{
				dd.n4RectVis(false);
				dd.obj.resizeTo(dd.obj.w, dd.obj.h);
			}
		}
		if (!dd.n4 && !dd.op6 && (dd.obj.div.pos_rel || dd.obj.is_resized)) dd.recalc();
		dd.setEvtHdl('move', dd.moveFunc);
		dd.setEvtHdl('up', dd.upFunc);
		if (dd.db) dd.db.onselectstart = null;
		dd.obj.setCursor(dd.obj.cursor);
		dd.obj.resetZ();
		if (window.my_DropFunc)
		{
			dd.e = new dd.evt(d_ev);
			my_DropFunc();
		}
		dd.mousemoved = dd.obj.is_dragged = dd.obj.is_resized = false;
		dd.obj = null;
	}
	dd.setEvtHdl('down', PICK);
}






function SET_DHTML()
{
	if (!(dd && (dd.n4 || dd.n6 || dd.ie || dd.op || dd.sfr))) return;

	var d_a = SET_DHTML.arguments,
	d_htm = '',
	d_o;
	for (var d_i = d_a.length-1; d_i >= 0; d_i--)
	{
		if (dd.op6)
		{
			var d_t0 = (new Date()).getTime();
			while ((new Date()).getTime()-d_t0 < 0x99);
		}
		// get global cmds
		if (!d_a[d_i].indexOf('c:')) dd.cursor = d_a[d_i].substring(0x02);
		else if (d_a[d_i] == NO_ALT) dd.noalt = true;
		else if (d_a[d_i] == NO_SCROLL) dd.noscroll = true;
		else if (d_a[d_i] == KEYDOWN_RESIZE) dd.keydown_resize = true;
		else if (d_a[d_i] == RESET_Z) dd.re_z = true;


		else
		{
			d_o = new DDObj(d_a[d_i]);
			if (d_o.oimg || d_o.div)
			{
				dd.addElt(d_o);
				d_o.defz = 0x03;
				d_htm += d_o.htm || '';
				if (d_o.oimg && d_o.cpy_n)
				{
					d_o.copies = new Array();
					for (var d_j = 1; d_j <= d_o.cpy_n; d_j++)
					{
						var d_p = new DDObj(
							d_o.name +
							(d_o.clone? CLONE : '') +
							(d_o.noalt? NOALT : '') +
							(d_o.noscroll? NOSCROLL : '') +
							(d_o.keydown_resize? KEYDOWN_RESIZE : '') +
							(d_o.re_z? RESET_Z : ''),
							d_j
						);
						dd.addElt(d_p, d_o);
						d_p.defz = d_o.defz+d_j;
						d_p.original = d_o;
						d_htm += d_p.htm;
					}
				}
			}
		}
	}


	if (dd.elements.length)
	{
		document.write(
			(dd.n4? '<div style="position:absolute;"><\/div>\n'
			: (dd.op && !dd.op6)? '<div id="OpBlUr" style="position:absolute;visibility:hidden;width:0px;height:0px;"><form><input type="text" style="width:0px;height:0px;"><\/form><\/div>'
			: '') + d_htm
		);
		dd.z = 0x32;


		for (d_i = 0; d_i < dd.elements.length; d_i++)
		{
			if ((d_o = dd.elements[d_i]).is_image && !d_o.original && !d_o.clone)
			{
				if (dd.n4) d_o.oimg.src = spacer;
				else d_o.oimg.style.visibility = 'hidden';
			}
			dd.addProps(d_o);
		}
		for (d_i = 0; d_i < dd.elements.length; d_i++)
			if (!(d_o = dd.elements[d_i]).is_image) dd.getChildren(d_o);


		if (window.onload) dd.loadFunc = window.onload;
		window.onload = dd.init;
		dd.setEvtHdl('down', PICK);
	}
}



function ADD_DHTML(d_o)
{
	// layers only!
	d_o = new DDObj(d_o);
	dd.addElt(d_o);
	dd.addProps(d_o);
	dd.getChildren(d_o);
}








////////////////////////////////////////////////////////////////////////////////
// If not needed, all code below this line may be removed
////////////////////////////////////////////////////////////////////////////////


// For backward compatibility only
dd.d = document;			// < v. 2.72
var RESET_ZINDEX = RESET_Z; // < 3.44






////////////////////////////////////////////////////////////////////////////////
// FUNCTIONS FOR EXTENDED SCRIPTING
// Use these for your own extensions,
// or to call functions defined elsewhere
////////////////////////////////////////////////////////////////////////////////


/* my_PickFunc IS AUTOMATICALLY CALLED WHEN AN ITEM STARTS TO BE DRAGGED.
The following objects/properties are accessible from here:

- dd.e: current mouse event
- dd.e.property: access to a property of the current mouse event.
  Mostly requested properties:
  - dd.e.x: document-related x co-ordinate
  - dd.e.y: document-related y co-ord
  - dd.e.src: target of mouse event (not identical with the drag drop object itself).
  - dd.e.button: currently pressed mouse button. Left button: dd.e.button <= 1

- dd.obj: reference to currently dragged item.
- dd.obj.property: access to any property of that item.
- dd.obj.method(): for example dd.obj.resizeTo() or dd.obj.swapImage() .
  Mostly requested properties:
	- dd.obj.name: image name or layer ID passed to SET_DHTML();
	- dd.obj.x and dd.obj.y: co-ordinates;
	- dd.obj.w and dd.obj.h: size;
	- dd.obj.is_dragged: true while item is dragged;
	- dd.obj.is_resized: true while item is resized, i.e. if <ctrl> or <shift> is pressed

For more properties and details, visit the API documentation
at http://www.walterzorn.com/dragdrop/api_e.htm (english) or
http://www.walterzorn.de/dragdrop/api.htm (german)    */
function my_PickFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + (dd.obj.is_dragged? ('.x = ' + dd.obj.x) : ('.w = ' + dd.obj.w)) + '      dd.elements.' + dd.obj.name + (dd.obj.is_dragged? ('.y = ' + dd.obj.y) : ('.h = ' + dd.obj.h));
}




/* my_DragFunc IS CALLED WHILE AN ITEM IS DRAGGED
See the description of my_PickFunc above for what's accessible from here. */
function my_DragFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + '.x  = ' + dd.obj.x + '     dd.elements.' + dd.obj.name + '.y = ' + dd.obj.y;
}




/* my_ResizeFunc IS CALLED WHILE AN ITEM IS RESIZED
See the description of my_PickFunc above for what's accessible from here. */
function my_ResizeFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + '.w  = ' + dd.obj.w + '     dd.elements.' + dd.obj.name + '.h = ' + dd.obj.h;
}




/* THIS ONE IS CALLED ONCE AN ITEM IS DROPPED
See the description of my_PickFunc for what's accessible from here.
Here may be investigated, for example, what's the name (dd.obj.name)
of the dropped item, and where (dd.obj.x, dd.obj.y) it has been dropped... */
function my_DropFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + (dd.obj.is_dragged? ('    dropped at x = ' + dd.obj.x + '      y = ' + dd.obj.y) : ('    resized to w = ' + dd.obj.w + '     h = ' + dd.obj.h));
}

